
package kom.itbeankit.common;

/**
 * This interface contains the methods, every object which want to listen
 * to an ItBeanCommunicationEvent have to implement.
 * @author Christian C. Hoffmann
 * @version 1.0 02/04/98
 */
public interface ItBeanCommunicationListener extends java.util.EventListener {

/**
 * This method is invoked by the object producing a 
 * bean iteration completed event.
 * @param e common.ItBeanCommunicationEvent
 */
public void beanCompleted(ItBeanCommunicationEvent e);
/**
 * This method is invoked by the object producing 
 * a bean interrupted event.
 * @param e common.ItBeanCommunicationEvent
 */
public void beanInterrupted(ItBeanCommunicationEvent e);
/**
 * This method will be invoked if a bean started event occurs in any ItBean.
 * @param e the occurred event 
 */
public void beanStarted(ItBeanCommunicationEvent e);
/**
 * This method is invoked by the object producing
 * a bean terminated event. 
 * @param e common.ItBeanCommunicationEvent
 */
public void beanTerminated(ItBeanCommunicationEvent e);
}